/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.blocks.PipeBlock;
import de.maxhenkel.pipez.capabilities.ModCapabilities;
import de.maxhenkel.pipez.corelib.blockentity.ITickableBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class PipeTileEntity
extends BlockEntity
implements ITickableBlockEntity {
    @Nullable
    protected List<Connection> connectionCache;
    @Nullable
    protected Connection[] extractingConnectionCache;
    protected boolean[] extractingSides = new boolean[Direction.values().length];
    protected boolean[] disconnectedSides = new boolean[Direction.values().length];
    private int invalidateCountdown;

    public PipeTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public List<Connection> getConnections() {
        if (this.f_58857_ == null) {
            return new ArrayList<Connection>();
        }
        if (this.connectionCache == null) {
            this.updateConnectionCache();
            if (this.connectionCache == null) {
                return new ArrayList<Connection>();
            }
        }
        return this.connectionCache;
    }

    @Nullable
    public Connection getExtractingConnection(Direction side) {
        if (this.f_58857_ == null) {
            return null;
        }
        if (this.extractingConnectionCache == null) {
            this.updateExtractingConnectionCache();
            if (this.extractingConnectionCache == null) {
                return null;
            }
        }
        return this.extractingConnectionCache[side.m_122411_()];
    }

    public static void markPipesDirty(Level world, BlockPos pos) {
        ArrayList<BlockPos> travelPositions = new ArrayList<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        Block block = world.m_8055_(pos).m_60734_();
        if (!(block instanceof PipeBlock)) {
            return;
        }
        PipeBlock pipeBlock = (PipeBlock)block;
        PipeTileEntity pipeTe = pipeBlock.getTileEntity((LevelAccessor)world, pos);
        if (pipeTe != null) {
            for (Direction side : Direction.values()) {
                if (!pipeTe.isExtracting(side) || pipeBlock.canConnectTo((LevelAccessor)world, pos, side)) continue;
                pipeTe.setExtracting(side, false);
                if (!pipeTe.hasReasonToStay()) {
                    pipeBlock.setHasData(world, pos, false);
                }
                pipeTe.syncData();
            }
        }
        travelPositions.add(pos);
        PipeTileEntity.addToDirtyList(world, pos, pipeBlock, travelPositions, queue);
        while (queue.size() > 0) {
            BlockPos blockPos = queue.removeFirst();
            block = world.m_8055_(blockPos).m_60734_();
            if (!(block instanceof PipeBlock)) continue;
            PipeTileEntity.addToDirtyList(world, blockPos, (PipeBlock)block, travelPositions, queue);
        }
        for (BlockPos p : travelPositions) {
            BlockEntity te = world.m_7702_(p);
            if (!(te instanceof PipeTileEntity)) continue;
            PipeTileEntity pipe = (PipeTileEntity)te;
            pipe.connectionCache = null;
        }
    }

    private static void addToDirtyList(Level world, BlockPos pos, PipeBlock pipeBlock, List<BlockPos> travelPositions, LinkedList<BlockPos> queue) {
        for (Direction direction : Direction.values()) {
            BlockPos p;
            if (!pipeBlock.isConnected((LevelAccessor)world, pos, direction) || travelPositions.contains(p = pos.m_121945_(direction)) || queue.contains(p)) continue;
            travelPositions.add(p);
            queue.add(p);
        }
    }

    private void updateConnectionCache() {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof PipeBlock)) {
            this.connectionCache = null;
            return;
        }
        if (!this.isExtracting()) {
            this.connectionCache = null;
            return;
        }
        HashMap<DirectionalPosition, Connection> connections = new HashMap<DirectionalPosition, Connection>();
        HashMap<BlockPos, Integer> queue = new HashMap<BlockPos, Integer>();
        ArrayList<BlockPos> travelPositions = new ArrayList<BlockPos>();
        this.addToQueue(this.f_58857_, this.f_58858_, queue, travelPositions, connections, 1);
        while (queue.size() > 0) {
            Map.Entry blockPosIntegerEntry = (Map.Entry)queue.entrySet().stream().findAny().get();
            this.addToQueue(this.f_58857_, (BlockPos)blockPosIntegerEntry.getKey(), queue, travelPositions, connections, (Integer)blockPosIntegerEntry.getValue());
            travelPositions.add((BlockPos)blockPosIntegerEntry.getKey());
            queue.remove(blockPosIntegerEntry.getKey());
        }
        this.connectionCache = new ArrayList(connections.values());
    }

    private void updateExtractingConnectionCache() {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof PipeBlock)) {
            this.extractingConnectionCache = null;
            return;
        }
        this.extractingConnectionCache = new Connection[Direction.values().length];
        for (Direction direction : Direction.values()) {
            this.extractingConnectionCache[direction.m_122411_()] = !this.isExtracting(direction) ? null : new Connection(this.m_58899_().m_121945_(direction), direction.m_122424_(), 1);
        }
    }

    public void addToQueue(Level world, BlockPos position, Map<BlockPos, Integer> queue, List<BlockPos> travelPositions, Map<DirectionalPosition, Connection> insertPositions, int distance) {
        Block block = world.m_8055_(position).m_60734_();
        if (!(block instanceof PipeBlock)) {
            return;
        }
        PipeBlock pipeBlock = (PipeBlock)block;
        for (Direction direction : Direction.values()) {
            if (!pipeBlock.isConnected((LevelAccessor)world, position, direction)) continue;
            BlockPos p = position.m_121945_(direction);
            DirectionalPosition dp = new DirectionalPosition(p, direction.m_122424_());
            Connection connection = new Connection(dp.getPos(), dp.getDirection(), distance);
            if (!this.isExtracting(this.f_58857_, position, direction) && this.canInsert(this.f_58857_, connection)) {
                if (!insertPositions.containsKey(dp)) {
                    insertPositions.put(dp, connection);
                    continue;
                }
                if (insertPositions.get(dp).getDistance() <= distance) continue;
                insertPositions.put(dp, connection);
                continue;
            }
            if (travelPositions.contains(p) || queue.containsKey(p)) continue;
            queue.put(p, distance + 1);
        }
    }

    private boolean isExtracting(Level level, BlockPos pos, Direction direction) {
        PipeTileEntity pipe;
        BlockEntity te = level.m_7702_(pos);
        return te instanceof PipeTileEntity && (pipe = (PipeTileEntity)te).isExtracting(direction);
    }

    public abstract boolean canInsert(Level var1, Connection var2);

    @Override
    public void tick() {
        if (this.invalidateCountdown >= 0) {
            --this.invalidateCountdown;
            if (this.invalidateCountdown <= 0) {
                this.connectionCache = null;
            }
        }
    }

    public boolean isExtracting(Direction side) {
        return this.extractingSides[side.m_122411_()];
    }

    public boolean isExtracting() {
        for (boolean extract : this.extractingSides) {
            if (!extract) continue;
            return true;
        }
        return false;
    }

    public boolean hasReasonToStay() {
        if (this.isExtracting()) {
            return true;
        }
        for (boolean disconnected : this.disconnectedSides) {
            if (!disconnected) continue;
            return true;
        }
        return false;
    }

    public void setExtracting(Direction side, boolean extracting) {
        this.extractingSides[side.m_122411_()] = extracting;
        this.extractingConnectionCache = null;
        this.m_6596_();
    }

    public boolean isDisconnected(Direction side) {
        return this.disconnectedSides[side.m_122411_()];
    }

    public void setDisconnected(Direction side, boolean disconnected) {
        this.disconnectedSides[side.m_122411_()] = disconnected;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.extractingSides = new boolean[Direction.values().length];
        ListTag extractingList = compound.m_128437_("ExtractingSides", 1);
        if (extractingList.size() >= this.extractingSides.length) {
            for (int i = 0; i < this.extractingSides.length; ++i) {
                ByteTag b = (ByteTag)extractingList.get(i);
                this.extractingSides[i] = b.m_7063_() != 0;
            }
        }
        this.disconnectedSides = new boolean[Direction.values().length];
        ListTag disconnectedList = compound.m_128437_("DisconnectedSides", 1);
        if (disconnectedList.size() >= this.disconnectedSides.length) {
            for (int i = 0; i < this.disconnectedSides.length; ++i) {
                ByteTag b = (ByteTag)disconnectedList.get(i);
                this.disconnectedSides[i] = b.m_7063_() != 0;
            }
        }
        this.invalidateCountdown = 10;
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ListTag extractingList = new ListTag();
        for (boolean extractingSide : this.extractingSides) {
            extractingList.add((Object)ByteTag.m_128273_((boolean)extractingSide));
        }
        compound.m_128365_("ExtractingSides", (Tag)extractingList);
        ListTag disconnectedList = new ListTag();
        for (boolean disconnected : this.disconnectedSides) {
            disconnectedList.add((Object)ByteTag.m_128273_((boolean)disconnected));
        }
        compound.m_128365_("DisconnectedSides", (Tag)disconnectedList);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void syncData(ServerPlayer player) {
        player.f_8906_.m_9829_(this.m_58483_());
    }

    public void syncData() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        LevelChunk chunk = this.f_58857_.m_46745_(this.m_58899_());
        ((ServerChunkCache)this.f_58857_.m_7726_()).f_8325_.m_183262_(chunk.m_7697_(), false).forEach(e -> e.f_8906_.m_9829_(this.m_58483_()));
    }

    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        this.m_183515_(updateTag);
        return updateTag;
    }

    public static class Connection {
        private final BlockPos pos;
        private final Direction direction;
        private final int distance;
        private LazyOptional<IItemHandler> itemHandler;
        private LazyOptional<IEnergyStorage> energyHandler;
        private LazyOptional<IFluidHandler> fluidHandler;
        private LazyOptional<IGasHandler> gasHandler;

        public Connection(BlockPos pos, Direction direction, int distance) {
            this.pos = pos;
            this.direction = direction;
            this.distance = distance;
            this.itemHandler = LazyOptional.empty();
            this.energyHandler = LazyOptional.empty();
            this.fluidHandler = LazyOptional.empty();
            this.gasHandler = LazyOptional.empty();
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public int getDistance() {
            return this.distance;
        }

        public String toString() {
            return "Connection{pos=" + this.pos + ", direction=" + this.direction + ", distance=" + this.distance + "}";
        }

        public LazyOptional<IItemHandler> getItemHandler(Level level) {
            if (!this.itemHandler.isPresent()) {
                this.itemHandler = this.getCapabilityRaw(level, ForgeCapabilities.ITEM_HANDLER);
            }
            return this.itemHandler;
        }

        public LazyOptional<IEnergyStorage> getEnergyHandler(Level level) {
            if (!this.energyHandler.isPresent()) {
                this.energyHandler = this.getCapabilityRaw(level, ForgeCapabilities.ENERGY);
            }
            return this.energyHandler;
        }

        public LazyOptional<IFluidHandler> getFluidHandler(Level level) {
            if (!this.fluidHandler.isPresent()) {
                this.fluidHandler = this.getCapabilityRaw(level, ForgeCapabilities.FLUID_HANDLER);
            }
            return this.fluidHandler;
        }

        public LazyOptional<IGasHandler> getGasHandler(Level level) {
            if (!this.gasHandler.isPresent()) {
                this.gasHandler = this.getCapabilityRaw(level, ModCapabilities.GAS_HANDLER_CAPABILITY);
            }
            return this.gasHandler;
        }

        public <T> LazyOptional<T> getCapability(Level level, Capability<T> capability) {
            if (capability == ForgeCapabilities.ITEM_HANDLER) {
                return this.getItemHandler(level).cast();
            }
            if (capability == ForgeCapabilities.ENERGY) {
                return this.getEnergyHandler(level).cast();
            }
            if (capability == ForgeCapabilities.FLUID_HANDLER) {
                return this.getFluidHandler(level).cast();
            }
            if (capability == ModCapabilities.GAS_HANDLER_CAPABILITY) {
                return this.getGasHandler(level).cast();
            }
            return LazyOptional.empty();
        }

        private <T> LazyOptional<T> getCapabilityRaw(Level level, Capability<T> capability) {
            BlockEntity te = level.m_7702_(this.pos);
            if (te == null) {
                return LazyOptional.empty();
            }
            if (te instanceof PipeTileEntity) {
                return LazyOptional.empty();
            }
            return te.getCapability(capability, this.direction);
        }
    }
}

